/*
	TAB=3 SPACES
	Fichier .H pour utiliser le driver rsident SNDDRV.EXE
	par F. Bellard pour ESAT Software.
	Modle mmoire: Compact, Large, ou Huge (les pointeurs doivent tre sur 32 bits)
*/

#include "common.h"

/***************************************************************************
	fonctions & dfinitions de la librairie DSOUND pour jouer des samples
****************************************************************************/

enum {
	DSCARD_HPPC,
	DSCARD_SB,
	DSCARD_SBDMA,
	DSCARD_ADLIB,
	DSCARD_PARA,
	DSCARD_COVOX,
	DSCARD_MINI
};

enum {
	DSER_NOERROR,
	DSER_BADPARAM,		
	DSER_NOMEMORY,	
	DSER_SOUNDINUSE,
	DSER_BADHARD,
	DSER_NODRIVER,
	DSER_DISK
};

enum {
	DSST_NOSOUND,
	DSST_SOUND,
	DSST_SOUNDSTOPPED,
	DSST_SOUNDERROR
};

enum {
	CARDONPC_NO,
	CARDONPC_YES,
	CARDONPC_UNKNOWN
};

#define	DSTYPE_UNSIGNED8		0x0001
#define	DSTYPE_STUNSIGNED8	0x0002
#define	DSTYPE_UNSIGNED16		0x0004
#define	DSTYPE_STUNSIGNED16	0x0008


typedef struct {
	WORD CardType;
	DWORD CardData;
	WORD SampleFreq;
	WORD SampleType;
	int far pascal (*SoundProc)(void *buf,WORD size);
} DSOUNDINFO;

typedef struct {
		WORD CardType;
		char CardName[41];
		WORD CardOnPC;

		WORD outFreqMax;
		WORD outFreqMin;
		WORD outFreqBest;
		WORD outSampleType;
		WORD outLowVolume;

		WORD inOption;
		WORD inFreqMin;
		WORD inFreqMax;
		WORD inFreqBest;
		WORD inSampleType;
} CARDINFO;


typedef struct {
		WORD NbCard;
		WORD BestCard;
} CARDGLOBALINFO;

int InitDSound(void);
void SetDSMemProc(void * far pascal (*mygetmem)(WORD len),void far pascal (*myfreemem)(void *p,WORD len));
void SetDSMemPtr(void *pt,DWORD size);
DWORD GetDSMemSize(void);

int StartDSound(DSOUNDINFO *SD);
int StopDSound(void);

int StartDSoundIN(DSOUNDINFO *SD);
int StopDSoundIN(void);

int GetDSoundStatus(void);

int GetCardInfo(CARDINFO *CINF);	
void GetCardGlobalInfo(CARDGLOBALINFO *CGINF);
WORD GetAccurateFreq(WORD ctype,DWORD cdata,WORD freq);


/***************************************************************************
	fonctions & dfinitions de la librairie RPMOD pour jouer des modules
****************************************************************************/

typedef struct {
	BYTE *splPtr;
	WORD splSize;
	WORD splRepAdr;
	WORD splRepLen;
	BYTE splFineTune;
	BYTE splVol;
} RPMSAMPLEREC;

typedef struct {
		WORD nbSample;
		RPMSAMPLEREC *Sample;
		char *SampleName;
		WORD nbVoice;
		WORD nbPattern;
		WORD **Pattern;
		WORD nbPatternIdx;
		BYTE PatternIdx[128];
		char ModTitle[21];
} RPMMODULE;

typedef struct {
		struct {
			WORD OK;
			WORD Vol;
			WORD Instr;
			WORD Period;
			WORD Bar;
		} Voice[8];
		WORD Pat;
		WORD PatIdx;
		WORD PatPos;
		WORD Speed;
		WORD Volout;
		short balance;
} RPMSTATUS;

int StartRPMod(DSOUNDINFO *DS,RPMMODULE *M);
int StopRPMod(void);

void SetRPMVoice(WORD voice,WORD vok);
void SetRPMVolout(WORD vout,WORD bal);
void SetRPMPattern(WORD pat);
void GetRPMStatus(RPMSTATUS *RPMS);

/***************************************************************************
	fonctions & dfinitions de la librairie RPMODIO pour charger les modules
****************************************************************************/

int LoadMod(RPMMODULE *M,char *name);
void FreeMod(RPMMODULE *M);

